<?php
/*
 本代码由 焕岱科技 创建
 技术支持 WX：15285007200
 严禁反编译、逆向等任何形式的侵权行为，违者将追究法律责任
*/

namespace app\admin\controller\bbfxshop\deposit_release;

use app\admin\controller\bbfxshop\Base;
use think\Db;
use app\common\model\bbfxshop\Order as OrderModel;


class Order extends Base
{
    
    public $model = null;
    public function _initialize(){
        parent::_initialize();
        $this->model = new \app\common\model\bbfxshop\DepositRelease;
    }

    public function getList(){
        $params = $this->param();
        
        $pindex = max(1, intval($params["page"]));
        $psize = intval($params["limit"])?intval($params["limit"]):10;
        
        $where = array("a.uniacid"=>UNIACID,"a.status"=>1);
        
        $keyword = trim($params['keyword']);
        $startTime = trim($params['startTime']);
        $endTime = trim($params['endTime']);
        $paytype = intval($params['paytype']);
        $type = intval($params['type']);
        
        
        if($keyword){
            if($type == 1){
                $where['a.order_no'] = ['like',"%".$keyword."%"];
            }
            else if($type == 2){
                $where['b.nickname'] = ['like',"%".$keyword."%"];
            }
            else if($type == 3){
                $where['a.user_id'] = intval($keyword);
            }
        }
        if($paytype > 0){
            $where['a.paytype'] = $paytype;
        }
        
        $whereTime = [];
        if($startTime){
            $startTime = strtotime($startTime." 00:00:00");
            $where['a.createtime'] = ['>=',$startTime];
        } 
        
        if($endTime){
            $endTime = strtotime($endTime." 23:59:59");
            $whereTime['a.createtime'] = ['<=',$endTime];
        }
        
        $list = Db::name("bbfx_deposit_release_order")->alias("a")->join("bbfx_user b","a.user_id=b.id")->where($where)->where($whereTime)->field('a.*,b.avatar,b.nickname')->order('a.createtime desc')->limit(($pindex - 1) * $psize,$psize)->select();
    	
    	foreach($list as $key => &$val){
    	    $val['avatar'] = cdnurl($val['avatar']);
    	    $val['paytypeText'] = "";
    	    $val['paytime'] = "";
    	    $val['statusText'] = "未支付";
    	    if($val['status'] == 1){
    	        $val['paytime'] = date("Y-m-d H:i:s",$val['pay_time']);
    	        $val['paytypeText'] = OrderModel::getOrderPaytype($val['paytype']);
    	        $val['statusText'] = "已支付";
    	    }
    	    
    	    $val['createtime'] = date("Y-m-d H:i:s",$val['createtime']);
    	    
    	}
    	unset($val);
      
        $total = Db::name("bbfx_deposit_release_order")->alias("a")->join("bbfx_user b","a.user_id=b.id")->where($where)->where($whereTime)->count();
    	
    	__success("操作成功",['total'=>$total,'list'=>$list]);
    }
}