<?php
/*
 本代码由 焕岱科技 创建
 技术支持 WX：15285007200
 严禁反编译、逆向等任何形式的侵权行为，违者将追究法律责任
*/

namespace app\admin\controller\bbfxshop\seckill;

use app\admin\controller\bbfxshop\Base;
use think\Db;


class Goods extends Base
{

    public $model = null;
    public function _initialize(){
        parent::_initialize();
        $this->model = new \app\common\model\bbfxshop\Seckill;
    }
    
    public function getList(){
        $params = $this->param();
        
        $pindex = max(1, intval($params["page"]));
        $psize = intval($params["limit"])?intval($params["limit"]):20;
        
        $where = ["a.uniacid"=>UNIACID];
        
        $keyword = trim($params['keyword']);
        if($keyword){
            $where['b.title'] = ['like','&'.$keyword.'&'];
        }
        
        
    	$list = Db::name("bbfx_seckill_goods")->alias("a")->join("bbfx_goods b","a.goods_id = b.id")->where($where)->field("a.*,b.title,b.thumb,b.price as o_price,b.type as goods_type,b.stock")->order("a.id desc")->limit(($pindex - 1) * $psize,$psize)->select();
      	foreach($list as $key => &$val){
      	    
        	$val['thumb'] = cdnurl($val['thumb']);
    	    $val['createtime'] = date("Y-m-d H:i:s",$val['createtime']);
    	    $val['starttime'] = date("Y-m-d H:i:s",$val['starttime']);
    	    $val['endtime'] = date("Y-m-d H:i:s",$val['endtime']);
        	
            $categorys = Db::name("bbfx_goods_category")->alias("a")->join("bbfx_category b","a.category_id=b.id")->where(['a.uniacid'=>UNIACID,'a.goods_id'=>$val['goods_id']])->field('b.id,b.title')->order('b.sort desc')->select();
        	
        	$val['categorys'] = $categorys;
        	
        	$typeText = "";
        	if($val['goods_type'] == 1){
        	    $typeText = "虚拟商品(卡密)";
        	}
        	else if($val['goods_type'] == 2){
        	    $typeText = "实体商品";
        	}
        	else if($val['goods_type'] == 3){
        	    $typeText = "核销商品";
        	}
        	else if($val['goods_type'] == 4){
        	    $typeText = "虚拟商品";
        	}
        	$val['goodsTypeText'] = $typeText;
        	
        	if($val['type'] == 2){
        	    $val['typeText'] = "限时折扣";
        	}
        	else{
        	    $val['typeText'] = "固定金额";
        	}
        	
        }
        unset($val);
    	$total = Db::name("bbfx_seckill_goods")->alias("a")->join("bbfx_goods b","a.goods_id = b.id")->where($where)->count();
        __success("操作成功",['total'=>$total,'list'=>$list]);
    }
    
    public function search(){
        $params = $this->param();
        
        $goodsids = trim($params['goodsids']);
        $goodsids = explode(",",$goodsids);
        
        $where = ['a.uniacid'=>UNIACID,'a.id'=>['in',$goodsids]];
        
        
        $list = Db::name("bbfx_seckill_goods")->alias("a")->join("bbfx_goods b","a.goods_id = b.id")->where($where)->field("a.*,b.title,b.thumb,b.price as o_price,b.type as goods_type,b.stock")->select();
        foreach ($list as $key => &$val){
            $val['thumb'] = cdnurl($val['thumb']);
            
            $cate_title = Db::name("bbfx_goods_category")->alias("a")->join("bbfx_category b","a.category_id=b.id")->where(['a.uniacid'=>UNIACID,'a.goods_id'=>$val['id']])->field('b.id,b.title')->value("title");
            
            if(!empty($cate_title)){
        	    $val['cate_title'] = $cate_title;
        	}
        	else{
        	    $val['cate_title'] = "";
        	}
        }
        unset($val);
        
        if(empty($list)){
            __error("未查询到数据");
        }
        else{
            __success("操作成功",$list);
        }
    }
    
    public function post(){
        $params = $this->param();
        
        $id = intval($params['id']);
        $goods = Db::name("bbfx_seckill_goods")->where(['id'=>$id])->find();
        
      	if($data['type'] == 1 && empty($params['price'])){
        	__error("请输入秒杀价格");
        }
        
        if(empty($params['goods_id'])){
        	__error("请选择商品");
        }
        
      	$price = floatval($params['price']);
    	$data = array(
        	"uniacid"=>UNIACID,
          	"price"=>$price,
          	"discount"=>floatval($params['discount']),
          	"status"=>intval($params['status']),
          	"type"=>intval($params['type']),
          	"is_fenxiao"=>intval($params['is_fenxiao']),
        );
        
        if($data['type'] == 2 && ($data['discount'] <= 0  || $data['discount'] > 10)){
            __error("请输入0.01至10之间的折扣");
        }
        
        if(!empty($goods)){
            $res = Db::name("bbfx_seckill_goods")->where(["id"=>$goods['id']])->update($data);
            $data['id'] = $goods['id'];
        }
      	else{
      	    $data['goods_id'] = $params['goods_id'];
          	$data['createtime'] = time();
            $res = Db::name("bbfx_seckill_goods")->insertGetId($data);
            $data['id'] = $res;
        }
        
        if($res){
            \app\admin\model\AdminLog::record("","",$data,"bbfx_seckill_goods");
            __success("操作成功");
        }
        else{
            __error("操作失败");
        }
    }
    public function detail(){
        $params = $this->param();
        
        $id = intval($params['id']);
        $goods = Db::name("bbfx_seckill_goods")->where(['id'=>$id])->find();
        
        if(!empty($goods)){
            __success("操作成功",$goods);
        }
        else{
            __error("商品不存在");
        }
    }
    
    public function status(){
        $params = $this->param();
        
        $id = intval($params['id']);
        $status = intval($params['status']);
        $res = Db::name("bbfx_seckill_goods")->where(["id"=>$id])->update(["status"=>$status]);
        if($res){
            \app\admin\model\AdminLog::record("","",["id"=>$id,"status"=>$status],"bbfx_seckill_goods");
            __success("操作成功");
        }
        else{
            __error(0,"操作失败");
        }
    }
    
    public function delete(){
        $params = $this->param();
        $ids = $params['id'];
        if(empty($ids)){
            __error("请选择需要删除的数据");
        }
        
        $ids = explode(",",$ids);
        
        foreach ($ids as $key => &$val){
            $val = intval($val);
        }
        unset($val);
        
        
      	$res = Db::name("bbfx_seckill_goods")->where('id','in',$ids)->delete();
      	if($res){
      	    \app\admin\model\AdminLog::record("","",["id"=>implode(",",$ids)],"bbfx_seckill_goods");
        	__success("删除成功");
        }
    	else{
        	__error("操作失败");
        }
    }
}