<?php
/*
 本代码由 焕岱科技 创建
 技术支持 WX：15285007200
 严禁反编译、逆向等任何形式的侵权行为，违者将追究法律责任
*/

namespace app\admin\controller\bbfxshop\user;

use app\admin\controller\bbfxshop\Base;
use think\Db;
use app\common\model\bbfxshop\User;


class Recharge extends Base
{
    
    public function _initialize(){
        parent::_initialize();
    }
    
    public function check(){
        $params = $this->param();
        
        $id = intval($params['id']);
        $status = intval($params['status']);
        $log = Db::name("bbfx_recharge_order")->where(["uniacid"=>UNIACID,"id"=>$id])->find();
        if(empty($log)){
            __error("充值记录不存在"); 
        }
        
        if(!in_array($status,[1,2])){
            __error("审核状态错误");  
        }
        
        if($log['status'] != 0){
            __error("已审核");  
        }
        
        if($log['mode'] == 1){
            __error("充值方式错误");  
        }
        
        try {
            Db::startTrans();
            $data = ["status"=>$status];
            $res = Db::name("bbfx_recharge_order")->where(['id'=>$log['id']])->update($data);
            if($res){
                if($status == 1){
                    $res = \app\common\model\bbfxshop\Order::rechargePayResult($log['order_no'],$log['mode']);
                    if(empty($res)){
                        throw new \Exception("充值失败");
                    }
                }
                $data['id'] = $log['id'];
                \app\admin\model\AdminLog::record("","",$data,'bbfx_recharge_order');
            }
            else{
                throw new \Exception("操作失败");
            }
            
            Db::commit();
        } 
        catch (\Exception $e) {
            Db::rollback();
            __error(0,$e->getMessage());
        }
        
        __success("操作成功"); 
        
    }
    
    public function getList(){
        $params = $this->param();
        
        $pindex = max(1, intval($params["page"]));
        $psize = intval($params["limit"])?intval($params["limit"]):10;
        $where = array("a.uniacid"=>UNIACID);
        $status = intval($params['status']);
        $startTime = trim($params['startTime']);
        $endTime = trim($params['endTime']);
        
        $keyword = trim($params['keyword']);
        
        $type = max(1,intval($params['type']));
        if(!empty($keyword)){
            
            if($type == 1){
                $where['b.nickname'] = ['like',"%".$keyword."%"];
            }
            else if($type == 2){
                $where['a.realname'] = ['like',"%".$keyword."%"];
            }
            else if($type == 3){
                $where['b.mobile'] = $keyword;
            }
            else if($type == 4){
                $where['a.user_id'] = intval($keyword);
            }
        }
         
        if($status){
            $where['a.status'] = $status;
        }
        
        $whereTime = [];
        if($startTime){
            $startTime = strtotime($startTime." 00:00:00");
            $where['a.createtime'] = ['>=',$startTime];
        }
        
        if($endTime){
            $whereTime['a.createtime'] = ['<=',$endTime];
        }
        $export = intval($params['export']);
        if($export == 1){
            $psize = 999999;
        }
        $where1 = function($query){
            $query->whereOr(function($query){
                $query->where(['a.mode'=>1,'a.is_pay'=>1]);
            });
            $query->whereOr(function($query){
                $query->where(['a.mode'=>['>',1]]);
            });
        };
        $list = Db::name("bbfx_recharge_order")->alias("a")->join("bbfx_user b","a.user_id=b.id")->where($where)->where($where1)->where($whereTime)->field('a.*,b.avatar,b.nickname')->order('a.createtime desc')->limit(($pindex - 1) * $psize,$psize)->select();
        
        $mode_list = ['1'=>'微信在线充值','2'=>'银行卡转账','3'=>'支付宝转账','4'=>'微信收款码','5'=>'支付宝收款码','6'=>'虚拟币','7'=>'数字人民币','8'=>'云闪付','9'=>'CB Pay','10'=>'JD Pay','11'=>'EB Pay','12'=>'DDB Pay','13'=>'MIN Pay'];
        
    	foreach($list as &$val){
    	    $val['avatar'] = cdnurl($val['avatar']);
    	    $val['pay_pingzheng'] = cdnurl($val['pay_pingzheng']);
    	    $val['createtime'] = date("Y-m-d H:i:s",$val['createtime']);
    	    if($val['paytime']){
    	        $val['paytime'] = date("Y-m-d H:i:s",$val['paytime']);
    	    }
    	    else{
    	        $val['paytime'] = "";
    	    }
            $type = "充值余额";
            if($val['type'] == 2){
                    $type = "充值积分";
            }
            
            $mode = $mode_list[$val['mode']];
            if(empty($mode)){
                $mode = "未知充值方式";
            }
            $val['type_text'] = $type;
            $val['mode_text'] = $mode;
    	    
    	    if($export == 1 && $val['is_pay'] == 1){
    	        
    	        $export_list[] = array(
    	            $val['id'],
    	            "【".$val['user_id']."】".$val['nickname'],
    	            $val['money'],
    	            $val['actual_money'],
    	            $type,
    	            $mode,
    	            $val['createtime']
    	        );
    	    }
    	}
    	unset($val);
    	
    	if($export == 1){
    	    $headArr = ["ID","用户信息","充值金额","实际到账","充值类型","充值方式","充值时间"];
    	    $result = \app\common\model\PhpOffice::excelExport("cz-".date("Y-m-d"),$headArr,$export_list);
    	}
      
    	$total = Db::name("bbfx_recharge_order")->alias("a")->join("bbfx_user b","a.user_id=b.id")->where($where)->where($where1)->where($whereTime)->count();
      	
        __success("操作成功",['total'=>$total,'list'=>$list]);
    }
    
    public function post(){
        $params = $this->param();
        
        $user_id = intval($params['user_id']);
        $type = intval($params['type']);
        $score = floatval($params['score']);
        $balance = floatval($params['balance']);
        $cz_type = intval($params['cz_type']);
        $notes = $params['notes'];
        if($cz_type == 1){
            if($score <= 0){
                __error("请输入充值积分");
            }
            if($type == 1){
                $score = 0 - $score;
            }            
            $result = User::setUserMoney($user_id,$score,2,3,"后台充值",['notes'=>$notes]);
        }else{
            if($balance <= 0){
                __error("请输入充值余额");
            }
            if($type == 1){
                $balance = 0 - $balance;
            } 
            $result = User::setUserMoney($user_id,$balance,1,3,"后台充值",['notes'=>$notes]);
        }
        
        if($result){
            $title = "余额充值";
            $content = "用户ID：{$user_id}，充值金额：{$balance}";
            if($cz_type == 1){
                $title = "积分充值";
                $content = "用户ID：{$user_id}，充值积分：{$score}";
            }
            
            \app\admin\model\AdminLog::record($title,$content,['notes'=>$notes]);
            
            __success("充值成功");
        }
        else{
            __error("充值失败");
        }
    }
}