<?php
/*
 本代码由 焕岱科技 创建
 技术支持 WX：15285007200
 严禁反编译、逆向等任何形式的侵权行为，违者将追究法律责任
*/

namespace app\admin\controller\bbfxshop\yajin;

use app\admin\controller\bbfxshop\Base;
use think\Db;
use app\common\model\bbfxshop\Order;

class Yajin extends Base
{

    public $model = null;
    public function _initialize(){
        parent::_initialize();
        $this->model = new \app\common\model\bbfxshop\Yajin;
    }
    
    public function getList(){
        $params = $this->param();
        
        $pindex = max(1, intval($params["page"]));
        $psize = intval($params["limit"])?intval($params["limit"]):10;
        $where = array("a.uniacid"=>UNIACID,'a.status'=>['>',0]);
        $status = intval($params['status']);
        $startTime = trim($params['startTime']);
        $endTime = trim($params['endTime']);
        
        $keyword = trim($params['keyword']);
        
        $type = max(1,intval($params['type']));
        if(!empty($keyword)){
            
            if($type == 1){
                $where['b.nickname'] = ['like',"%".$keyword."%"];
            }
            else if($type == 2){
                $where['a.user_id'] = intval($keyword);
            }
        }
         
        if($status > 0){
            $where['a.status'] = intval($status);
        }
        
        $whereTime = [];
        if($startTime){
            $startTime = strtotime($startTime." 00:00:00");
            $where['a.createtime'] = ['>=',$startTime];
        }
        
        if($endTime){
            $whereTime['a.createtime'] = ['<=',$endTime];
        }
        
        $list = Db::name("bbfx_yajin_record")->alias("a")->join("bbfx_user b","a.user_id=b.id")->where($where)->where($whereTime)->field('a.*,b.avatar,b.nickname')->order('a.createtime desc')->limit(($pindex - 1) * $psize,$psize)->select();
        
    	foreach($list as &$val){
    	    $val['avatar'] = cdnurl($val['avatar']);
    	    $val['createtime'] = date("Y-m-d H:i:s",$val['createtime']);
    	    if($val['paytime']){
    	        $val['paytime'] = date("Y-m-d H:i:s",$val['paytime']);
    	    }
    	    else{
    	        $val['paytime'] = "";
    	    }
    	    
    	    $val['paytype_text'] = Order::getOrderPaytype($val['paytype']);
    	}
    	unset($val);
      
    	$total = Db::name("bbfx_yajin_record")->alias("a")->join("bbfx_user b","a.user_id=b.id")->where($where)->where($whereTime)->count();
      	
        __success("操作成功",['total'=>$total,'list'=>$list]);
    }
}