<?php
/*
 本代码由 焕岱科技 创建
 技术支持 WX：15285007200
 严禁反编译、逆向等任何形式的侵权行为，违者将追究法律责任
*/

namespace app\api\controller\order;

use app\api\controller\Base;
use think\Db;
use app\common\model\bbfxshop\User;


class Comment extends Base
{
    protected $noNeedLogin = [];
    protected $noNeedRight = ['*'];
    
    public $model = null;
    public function _initialize(){
        parent::_initialize();
        $this->model = new \app\common\model\bbfxshop\Order;
    }
    
    public function getList(){
        
        $goods_id = $this->param("goods_id/d");
        $current = $this->param("current/d");
        
        $where = ['a.uniacid'=>UNIACID,'a.sh_status'=>1,'a.goods_id'=>$goods_id];
        $where1 = $where;
        if($current == 1){
            $where['a.images'] = ['neq','NOT NULL'];
        }
        else if($current == 2){
            $where['a.score'] = ['>=',4];
        }
        else if($current == 3){
            $where['a.score'] = ['<=',3];
        }
        
        $list = Db::name("bbfx_goods_comment")->alias("a")->join("bbfx_user b","a.user_id=b.id","LEFT")->where($where)->order("a.createtime desc")->field("a.*,b.avatar,b.nickname")->select();
        
        foreach ($list as $key => &$val){
            $val['createtime'] = date("Y-m-d H:i:s",$val['createtime']);
            $val['images'] = cdnurls(iunserializer($val['images']));
            $val['info'] = iunserializer($val['info']);
    	    $val['info']['thumb'] = cdnurl($val['info']['thumb']);
    	    $val['avatar'] = cdnurl($val['avatar']);
    	    
    	    $zan_num = Db::name("bbfx_comment_zan")->where(['uniacid'=>UNIACID,'type'=>0,'pid'=>$val['id']])->count();
    	    $val['zan_num'] = intval($zan_num);
    	    
    	    $zan = Db::name("bbfx_comment_zan")->where(['uniacid'=>UNIACID,'user_id'=>$this->user['id'],'type'=>0,'pid'=>$val['id']])->count();
    	    $val['is_zan'] = 0;
    	    if(!empty($zan)){
    	        $val['is_zan'] = 1;
    	    }
        }
        unset($val);
        $where1 = ['uniacid'=>UNIACID,'sh_status'=>1,'goods_id'=>$goods_id];
        $current0 = Db::name("bbfx_goods_comment")->where($where1)->count();
        $current1 = Db::name("bbfx_goods_comment")->where($where1)->where(['images'=>['neq','NOT NULL']])->count();
        $current2 = Db::name("bbfx_goods_comment")->where($where1)->where(['score'=>['>=',4]])->count();
        $current3 = Db::name("bbfx_goods_comment")->where($where1)->where(['score'=>['<=',3]])->count();
        
        $count[] = $current0;
        $count[] = $current1;
        $count[] = $current2;
        $count[] = $current3;
        
        __success("操作成功",['list'=>$list,'count'=>$count]);
    }
    
    public function zan(){
        $id = $this->param("id/d");
        
        $comment = Db::name("bbfx_goods_comment")->where(['id'=>$id])->find();
        
        if(empty($comment)){
            __error("评论不存在");
        }
        
        $comment_zan = Db::name("bbfx_comment_zan")->where(['uniacid'=>UNIACID,'type'=>0,'user_id'=>$this->user['id'],'pid'=>$id])->find();
        if(!empty($comment_zan)){
            $res = Db::name("bbfx_comment_zan")->where(['id'=>$comment_zan['id']])->delete();
        }
        else{
            $data = ['uniacid'=>UNIACID,'user_id'=>$this->user['id'],'type'=>0,'pid'=>$id,'createtime'=>time()];
            $res = Db::name("bbfx_comment_zan")->insert($data);
        }
        
        if($res){
            __success("操作成功");
        }
        else{
            __error("操作失败");
        }
    }
    
    public function post(){
        global $_W;
        
        $goodsset = $_W['base']['goodsset'];
        
        $params = $this->param(['order_id/d','goods_id/d','content/s','score/d','images/a']);
        
        if($goodsset['goods_comment'] != 1){
            __error("未开启商品评价");
        }
        
        if(empty($params['order_id'])){
            __error("订单ID错误");
        }
        if(empty($params['goods_id'])){
            __error("商品ID错误");
        }
        if(empty($params['content'])){
            __error("请输入评论内容");
        }
        if($params['score'] <= 0){
            __error("请选择评分");
        }
        
        $order_goods = Db::name("bbfx_order_goods")->alias("og")->join("bbfx_order o","og.order_id=o.id","LEFT")->where(['o.uniacid'=>UNIACID,'o.is_pay'=>1,'o.id'=>$params['order_id'],'og.goods_id'=>$params['goods_id']])->field("og.*")->find();
        if(empty($order_goods)){
            __error("订单商品不存在");
        }
        
        $goods = Db::name("bbfx_goods")->where(['uniacid'=>UNIACID,'id'=>$params['goods_id']])->field("id,title,thumb,price,stock,type,o_price,minbuy,maxbuy,total_maxbuy,unit,sales_volume,is_nodiscount,is_leveldiscount_rule,level_discount,content")->find();
        if(empty($goods)){
            __error("商品错误");
        }
        
        $data = array(
            "uniacid"=>UNIACID,
            "user_id"=>$this->user['id'],
            "goods_id"=>$params['goods_id'],
            "order_id"=>$params['order_id'],
            "score"=>$params['score'],
            "content"=>$params['content'],
            "info"=>iserializer($goods),
            "createtime"=>time(),
            "sh_status"=>1
        );
        
        if($goodsset['goods_comment_shenhe'] == 1){
            $data['sh_status'] = 0;
        }
        
        if(!empty($params['images'])){
            $data['images'] = iserializer(replaceSiteroots($params['images']));
        }
        
        $comment = Db::name("bbfx_goods_comment")->where(['uniacid'=>UNIACID,'order_id'=>$params['order_id'],'goods_id'=>$params['goods_id']])->find();
        if(!empty($comment)){
            __error("已评论");
        }
        
        $res = Db::name("bbfx_goods_comment")->insert($data);
        
        if($res){
            __success("提交成功");
        }
        else{
            __error("操作失败");
        }
    }
}