<?php
/*
 本代码由 焕岱科技 创建
 技术支持 WX：15285007200
 严禁反编译、逆向等任何形式的侵权行为，违者将追究法律责任
*/

namespace app\api\controller\short_video;

use app\api\controller\Base;
use think\Db;
use app\common\model\bbfxshop\User;


class Comment extends Base
{
    protected $noNeedLogin = ['getList'];
    protected $noNeedRight = ['*'];
    
    public $model = null;
    public function _initialize(){
        parent::_initialize();
        $this->model = new \app\common\model\bbfxshop\ShortVideo;
    }
    
    // 评论
    public function submit(){
        global $_W;
        $params = $this->param(['video_id/d','reply_id/d','reply_pid/d','content/s']);
        if(empty($params['content'])){
            __error("请输入评论内容");
        }
        
        $data = array(
            "uniacid"=>UNIACID,
            "user_id"=>$this->user['id'],
            "pid"=>$params['video_id'],
            "reply_id"=>$params['reply_id'],
            "reply_pid"=>$params['reply_pid'],
            "content"=>$params['content'],
            "status"=>0,
            "createtime"=>time()
        );
        
        if($_W['base']['short_video']['comment_verify'] != 1){
            $data['status'] = 1;
        }
        
        if($data['reply_pid'] == 0){
            $data['reply_pid'] = $params['reply_id'];
        }
        
        $res = Db::name("bbfx_short_video_comment")->insert($data);
        if($res){
            __success("评论成功");
        }
        else{
            __error("评论失败");
        }
    }
    
    // 评论列表
    public function getList(){
        $video_id = $this->param("video_id/d");
        $list = Db::name("bbfx_short_video_comment")->alias("a")->join("bbfx_user b","a.user_id=b.id","LEFT")->where(['a.uniacid'=>UNIACID,'a.pid'=>$video_id,'a.reply_id'=>0,'a.status'=>1])->order("a.createtime asc")->field("a.*,b.avatar,b.nickname")->select();
        if(!empty($list)){
            
            $dianzans = Db::name("bbfx_short_video_comment_dianzan")->where(['uniacid'=>UNIACID,'pid'=>$video_id,'user_id'=>$this->user['id']])->field("id,comment_id,status")->select();
            
            $dianzans = array_skey($dianzans,"comment_id");
            
            foreach ($list as $key => &$val){
                $val['avatar'] = cdnurl($val['avatar']);
                $val['time'] = timeConvert($val['createtime']);
                $reply_list = Db::name("bbfx_short_video_comment")->alias("a")->join("bbfx_user b","a.user_id=b.id","LEFT")->where(['a.uniacid'=>UNIACID,'a.pid'=>$video_id,'a.reply_pid'=>$val['id'],'a.status'=>1])->order("a.createtime asc")->field("a.*,b.avatar,b.nickname")->select();
                $val['dz_status'] = -1;
                if(!empty($dianzans[$val['id']])){
                    $val['dz_status'] = $dianzans[$val['id']]['status'];
                }
                
                
                foreach ($reply_list as $k => &$v){
                    $v['avatar'] = cdnurl($v['avatar']);
                    $v['time'] = timeConvert($v['createtime']);
                    
                    $user = Db::name("bbfx_short_video_comment")->alias("a")->join("bbfx_user b","a.user_id=b.id","LEFT")->where(['a.uniacid'=>UNIACID,'a.pid'=>$video_id,'a.id'=>$v['reply_id'],'a.status'=>1])->field("b.avatar,b.nickname")->find();
                    
                    $v['reply_avatar'] = cdnurl($user['avatar']);
                    $v['reply_nickname'] = $user['nickname'];
                    
                    $v['dz_status'] = -1;
                    if(!empty($dianzans[$v['id']])){
                        $v['dz_status'] = $dianzans[$v['id']]['status'];
                    }
                }
                unset($v);
                $val['reply_list'] = $reply_list;
            }
            unset($val);
        }
        else{
            $list = [];
        }
        
        __success("操作成功",['list'=>$list]);
    }
    
    // 评论点赞
    public function dianzan(){
        $id = $this->param("id/d");
        $comment = Db::name("bbfx_short_video_comment")->where(['uniacid'=>UNIACID,'status'=>1,'id'=>$id])->find();
        if(empty($comment)){
            __error("评论不存在");
        }
        
        $dianzan = Db::name("bbfx_short_video_comment_dianzan")->where(['uniacid'=>UNIACID,'comment_id'=>$comment['id'],'user_id'=>$this->user['id']])->find();
        $dz_num = $comment['dz_num'];
        $cai_num = $comment['cai_num'];
        $dz_status = -1;
        if(!empty($dianzan)){
            if($dianzan['status'] == 1){
                if($dz_num > 0){
                    $dz_num--;
                    Db::name("bbfx_short_video_comment")->where(['id'=>$comment['id']])->setDec("dz_num",1);
                }
                else{
                    $dz_num = 0;
                }
                Db::name("bbfx_short_video_comment_dianzan")->where(['id'=>$dianzan['id']])->delete();
            }
            else{
                Db::name("bbfx_short_video_comment_dianzan")->where(['id'=>$dianzan['id']])->update(['status'=>1,'updatetime'=>time()]);
                if($cai_num > 0){
                    Db::name("bbfx_short_video_comment")->where(['id'=>$comment['id']])->setDec("cai_num",1);
                    $cai_num--;
                }
                else{
                    $cai_num = 0;
                }
                $dz_num++;
                $dz_status = 1;
                Db::name("bbfx_short_video_comment")->where(['id'=>$comment['id']])->setInc("dz_num",1);
            }
        }
        else{
            $dz_num++;
            $data = array(
                'uniacid'=>UNIACID,
                'pid'=>$comment['pid'],
                'comment_id'=>$comment['id'],
                'status'=>1,
                'user_id'=>$this->user['id'],
                'updatetime'=>time(),
                'createtime'=>time()
            );
            Db::name("bbfx_short_video_comment_dianzan")->insert($data);
            Db::name("bbfx_short_video_comment")->where(['id'=>$comment['id']])->setInc("dz_num",1);
            $dz_status = 1;
        }
        
        __success("操作成功",['dz_num'=>$dz_num,'cai_num'=>$cai_num,'dz_status'=>$dz_status]);
    }
    
    // 评论踩
    public function cai(){
        $id = $this->param("id/d");
        $comment = Db::name("bbfx_short_video_comment")->where(['uniacid'=>UNIACID,'status'=>1,'id'=>$id])->find();
        if(empty($comment)){
            __error("评论不存在");
        }
        
        $dianzan = Db::name("bbfx_short_video_comment_dianzan")->where(['uniacid'=>UNIACID,'comment_id'=>$comment['id'],'user_id'=>$this->user['id']])->find();
        $dz_num = $comment['dz_num'];
        $cai_num = $comment['cai_num'];
        $dz_status = -1;
        if(!empty($dianzan)){
            if($dianzan['status'] == 0){
                if($cai_num > 0){
                    $cai_num--;
                    Db::name("bbfx_short_video_comment")->where(['id'=>$comment['id']])->setDec("cai_num",1);
                }
                else{
                    $cai_num = 0;
                }
                Db::name("bbfx_short_video_comment_dianzan")->where(['id'=>$dianzan['id']])->delete();
            }
            else{
                Db::name("bbfx_short_video_comment_dianzan")->where(['id'=>$dianzan['id']])->update(['status'=>0,'updatetime'=>time()]);
                if($dz_num > 0){
                    Db::name("bbfx_short_video_comment")->where(['id'=>$comment['id']])->setDec("dz_num",1);
                    $dz_num--;
                }
                else{
                    $dz_num = 0;
                }
                $cai_num++;
                $dz_status = 0;
                Db::name("bbfx_short_video_comment")->where(['id'=>$comment['id']])->setInc("cai_num",1);
            }
        }
        else{
            
            $cai_num++;
            $data = array(
                'uniacid'=>UNIACID,
                'pid'=>$comment['pid'],
                'comment_id'=>$comment['id'],
                'status'=>0,
                'user_id'=>$this->user['id'],
                'updatetime'=>time(),
                'createtime'=>time()
            );
            Db::name("bbfx_short_video_comment_dianzan")->insert($data);
            Db::name("bbfx_short_video_comment")->where(['id'=>$comment['id']])->setInc("dz_num",1);
            $dz_status = 0;
        }
        
        __success("操作成功",['dz_num'=>$dz_num,'cai_num'=>$cai_num,'dz_status'=>$dz_status]);
    }
}