<?php
/*
 本代码由 焕岱科技 创建
 技术支持 WX：15285007200
 严禁反编译、逆向等任何形式的侵权行为，违者将追究法律责任
*/

namespace app\api\controller\store_client;

use app\api\controller\Base;
use think\Db;


class Store extends Base
{
    protected $noNeedLogin = ['getList','info'];
    protected $noNeedRight = ['*'];
    
    public $model = null;
    public function _initialize(){
        parent::_initialize();
        $this->model = new \app\common\model\bbfxshop\Store;
    }
    
    public function info(){
        $id = $this->param("id/d");
        $store = $this->model->getInfo($id);
        if(empty($store)){
           __error('门店不存在'); 
        }
        $store['logo'] = cdnurl($store['logo']);
        __success('操作成功',$store);
    }
    
    public function getList(){
        $goods_ids = $this->param("goods_ids/s");
        $page = $this->param("page/d");
        $is_reservation = $this->param("is_reservation/d");
        $keyword = $this->param("keyword/s");
        $lat = $this->param("lat/f");
        $lng = $this->param("lng/f");
        $goods_type = $this->param("goods_type/d");
        $page = max(1,$page);
        $limit = 10;
        
        
        $list = [];
        if(!empty($goods_ids)){
            
            $where = ['uniacid'=>UNIACID,'status'=>1];
            
            if(!empty($keyword)){
                $where['name'] = ['like','%'.$keyword.'%'];
            }
            
            
            $goods_ids = explode(",",$goods_ids);
            if($goods_type == 1){
                $goods = Db::name("bbfx_scoreshop_goods")->where(['uniacid'=>UNIACID,'status'=>1,'type'=>['in',[2,4]],'id'=>['in',$goods_ids]])->field("id,type,delivery_method,is_hexiao,hexiao_store_type")->select();
                $where['mid'] = 0;
            }
            else if($goods_type == 2){
                $pintuan_goods = Db::name("bbfx_pintuan_goods")->where(['id'=>['in',$goods_ids]])->select();
                $goods_ids = array_column($pintuan_goods,"goods_id");
                $goods = Db::name("bbfx_goods")->where(['uniacid'=>UNIACID,'status'=>1,'type'=>['in',[2,4]],'id'=>['in',$goods_ids]])->field("id,type,delivery_method,is_hexiao,hexiao_store_type")->select();
                $where['mid'] = 0;
            }
            else{
                $goods = Db::name("bbfx_goods")->where(['uniacid'=>UNIACID,'status'=>1,'type'=>['in',[2,4]],'id'=>['in',$goods_ids]])->field("id,mid,type,delivery_method,is_hexiao,hexiao_store_type")->select();
                
                $mid = 0;
                if(!empty($goods)){
                    foreach ($goods as $k => $v){
                        if($v['mid'] > 0){
                            $mid = $v['mid'];
                        }
                    }
                }
                
                $where['mid'] = $mid;
            }
            
            
            
            $store_list = Db::name("bbfx_store")->where($where)->order("sort desc")->field("id,user_id,name,logo,realname,mobile,yy_time,province,city,area,address,lng,lat,is_reservation,score,introduction")->select();
            
            
            foreach ($store_list as $key => $val){
                $flag = true;
                foreach ($goods as $k => $v){
                    if(($v['type'] == 2 && ($v['delivery_method'] == 2 || $v['delivery_method'] == 3)) || ($v['type'] == 4 && $v['is_hexiao'] == 1)){
                        
                        if($v['hexiao_store_type'] == 1){
                            if($goods_type == 1){
                                $store_goods = Db::name("bbfx_scoreshop_store_goods")->where(['uniacid'=>UNIACID,'goods_id'=>$v['id'],'store_id'=>$val['id']])->find();
                            }
                            else{
                                $store_goods = Db::name("bbfx_store_goods")->where(['uniacid'=>UNIACID,'goods_id'=>$v['id'],'store_id'=>$val['id']])->find();
                            }
                            
                            if(empty($store_goods)){
                                $flag = false;
                            }
                        
                        }
                    }
                }
                if($flag){
                    $list[] = $val;
                }
            }
            $total = count($list);
        }
        else{
            
            $where = ['uniacid'=>UNIACID,'mid'=>0,'status'=>1,'is_reservation'=>$is_reservation];
            
            if(!empty($keyword)){
                $where['name'] = ['like','%'.$keyword.'%'];
            }
            
            $list = Db::name("bbfx_store")->where($where)->order("sort desc")->field("id,user_id,name,logo,realname,mobile,yy_time,province,city,area,address,lng,lat,is_reservation,score,introduction")->select();
            $total = Db::name("bbfx_store")->where($where)->count();
            
        }
        
        foreach ($list as $key => &$val){
            $val['logo'] = cdnurl($val['logo']);
            $distance = 9999999;
            if(!empty($lng) || !empty($lat) || !empty($val['lng']) || !empty($val['lat'])){
                $distance = getdistance($lng,$lat,$val['lng'],$val['lat']);
            }
            $val['distance'] = $distance;
            $val['distanceText'] = "";
            if($distance != 9999999){
                $val['distanceText'] = $distance."km";
            }
        }
        unset($val);
        
        $distances = array_column($list,'distance');
        array_multisort($distances,SORT_ASC,$list);
        
        $list = array_slice($list, ($page-1)*$limit, $limit);
        
        __success("操作成功",['list'=>$list,'total'=>$total]);
    }
}