<?php
/*
 本代码由 焕岱科技 创建
 技术支持 WX：15285007200
 严禁反编译、逆向等任何形式的侵权行为，违者将追究法律责任
*/

namespace app\common\model\bbfxshop;

use think\Model;
use think\Db;
use app\common\model\bbfxshop\User;
use app\common\model\bbfxshop\Order;


class Gift extends Model
{
    public static function getSet(){
        global $_W;
        $base = $_W['base'];
        if(empty($base)){
            $base = \app\common\model\bbfxshop\Common::getConfig(true);
        }
        
        return $base['gift'];
    }

    public function receive($order_no,$user_id,$tx_status,$address_id=0,$hexiao_realname='',$hexiao_mobile=''){
        

        $order = Db::name("bbfx_order")->where(['order_no'=>$order_no,'uniacid'=>UNIACID,'gift_status'=>['>',-1],'status'=>1])->find();

        if(empty($order)){
            __error("礼品不存在");
        }

        if($order['refund_status'] == 1 || $order['refund_status'] == 0){
            __error('礼品订单已申请售后');
        }

        if($order['gift_status'] !== 0){
            __error('礼品已被领取');
        }

        $user = User::getInfo($user_id);
        if(empty($user)){
            return __json(0,'用户信息错误');
        }

        try {
            
            Db::startTrans();

            $res = Db::name("bbfx_order")->where(['id'=>$order['id'],'gift_status'=>0])->update(['gift_status'=>1]);
            if(empty($res)){
                throw new \Exception('礼品已被领取');
            }
            
            $udata = ['status'=>3,'gift_receive_time'=>time(),'gift_user_id'=>$user['id']];
            $where = ['id'=>$order['id'],'gift_status'=>1];
            $goods = iunserializer($order['goods_info'])[0];
            if(empty($goods)){
                throw new \Exception('商品信息错误');
            }
            $plugin = iunserializer($goods["plugin"]);
            $gift = $plugin['gift'];
            $is_user_order = false;
            if($tx_status == 1){
                if($gift['tx_status'] != 1){
                    throw new \Exception('未开启礼品提现');
                }
                $money = round($gift['cash'],2); 
                if($money > 0){
                    User::setUserMoney($user['id'],$money,1,41,"礼品金额提现",$order);
                }
                Order::complete($order);
            }
            else{
                
                if($order['user_id'] != $user['id']){

                    Order::complete($order);

                    $order_no = date('YmdHis').random(8,true);  

                    $order_data = array(
                        "uniacid"=>UNIACID,
                        "order_no"=>$order_no,
                        "user_id"=>$user['id'],
                        "order_type"=>$order['order_type'],
                        "order_source"=>6,
                        "price"=>0,
                        "total_price"=>$order['total_price'],
                        "discount_price"=>$order['discount_price'],
                        "original_price"=>$order['original_price'],
                        "goods_info"=>$order['goods_info'],
                        "is_hexiao"=>$order['is_hexiao'],
                        "hexiao_realname"=>$order['hexiao_realname'],
                        "hexiao_mobile"=>$order['hexiao_mobile'],
                        "hexiao_total"=>$order['hexiao_total'],
                        "hexiao_num"=>$order['hexiao_num'],
                        "hexiao_code"=>random(8,true),
                        "hexiao_store"=>$order['hexiao_store'],
                        "delivery_method"=>$order['delivery_method'],
                        "delivery_username"=>$order['delivery_username'],
                        "delivery_mobile"=>$order['delivery_mobile'],
                        "delivery_province"=>$order['delivery_province'],
                        "delivery_city"=>$order['delivery_city'],
                        "delivery_area"=>$order['delivery_area'],
                        "delivery_street"=>$order['delivery_street'],
                        "delivery_address"=>$order['delivery_address'],
                        'remarks'=>'',
                        'platform'=>$user['platform'],
                        'pay_time'=>time(),
                        'is_pay'=>1,
                        'status'=>1,
                        'paytype'=>2,
                        "createtime"=>time()
                    );
                    
                    
                    if($order['order_type'] == 2 && $order['is_hexiao'] != 1){

                        if($order_data['user_id'] != $order['user_id']){
                            $address = Db::name("bbfx_user_address")->where(['id'=>$address_id,'user_id'=>$user['id']])->find();
                            if(empty($address)){
                                throw new \Exception("请选择收货地址");
                            }
                            
                            $order_data['delivery_username'] = $address['consignee'];
                            $order_data['delivery_mobile'] = $address['phone'];
                            $order_data['delivery_province'] = $address['province_name'];
                            $order_data['delivery_city'] = $address['city_name'];
                            $order_data['delivery_area'] = $address['area_name'];
                            $order_data['delivery_street'] = $address['street_name'];
                            $order_data['delivery_address'] = $address['address'];
                        }
                        
                    }
                    
                    if($order_data['is_hexiao'] == 1){
                        if($order_data['user_id'] != $order['user_id']){
                            if(empty($hexiao_realname)){
                                throw new \Exception("用户姓名错误");
                            }
                            if(empty($hexiao_mobile)){
                                throw new \Exception("用户手机错误");
                            }
                        }
                        if(!empty($hexiao_realname) && !empty($hexiao_mobile)){
                            $order_data['hexiao_realname'] = $hexiao_realname;
                            $order_data['hexiao_mobile'] = $hexiao_mobile;
                        }
                    }
                    
                    $order_id = Db::name("bbfx_order")->insertGetId($order_data);
                    if(empty($order_id)){
                        throw new \Exception("创建订单失败");
                    }
                    
                    $order_data['id'] = $order_id;

                    $order_goods = Db::name("bbfx_order_goods")->where(['uniacid'=>UNIACID,'order_id'=>$order['id']])->select();
                    foreach($order_goods as $k=>$val){
                        
                        $order_goods_data = [
                            "uniacid"=>UNIACID,
                            "order_id"=>$order_id,
                            "user_id"=>$user['id'],
                            "total"=>$val['total'],
                            "price"=>0,
                            "total_price"=>$val['total_price'],
                            "discount_price"=>$val['discount_price'],
                            "goods_id"=>$val['goods_id'],
                            "goods_info"=>$val['goods_info'],
                            "sku_id"=>$val['sku_id'],
                            "sku_name"=>$val['sku_name'],
                            "sku"=>$val['sku'],
                            "createtime"=>time()
                        ];

                        $res = Db::name("bbfx_order_goods")->insert($order_goods_data);
                        if(empty($res)){
                            throw new \Exception("创建订单失败");
                        }
                    }
                    
                }
                else{

                    $is_user_order = true;

                    $udata["status"] = 1;
                    $udata["gift_status"] = -1;

                    if($order['order_type'] == 2 && $order['is_hexiao'] != 1){
                        
                        $address = Db::name("bbfx_user_address")->where(['id'=>$address_id,'user_id'=>$user['id']])->find();
                        if(empty($address)){
                            throw new \Exception("请选择收货地址");
                        }
                        
                        $udata['delivery_username'] = $address['consignee'];
                        $udata['delivery_mobile'] = $address['phone'];
                        $udata['delivery_province'] = $address['province_name'];
                        $udata['delivery_city'] = $address['city_name'];
                        $udata['delivery_area'] = $address['area_name'];
                        $udata['delivery_street'] = $address['street_name'];
                        $udata['delivery_address'] = $address['address'];
                    }
                    
                    if($order['is_hexiao'] == 1){
                        if(empty($hexiao_realname)){
                            throw new \Exception("用户姓名错误");
                        }
                        if(empty($hexiao_mobile)){
                            throw new \Exception("用户手机错误");
                        }
                        if(!empty($hexiao_realname) && !empty($hexiao_mobile)){
                            $udata['hexiao_realname'] = $hexiao_realname;
                            $udata['hexiao_mobile'] = $hexiao_mobile;
                        }
                    }

                    $where['user_id'] = $user['id'];
                }
            }
            
            Db::name("bbfx_order")->where($where)->update($udata);

            if($is_user_order){
                Order::takeDelivery($order['id']);
            }

            $result = __json(1,"领取成功");
        	Db::commit();
        } 
        catch (\Exception $e) {
            Db::rollback();
        	$msg = $e->getMessage();
        	$result = __json(0,$msg);
        }
        
        return $result;
    }
}