<?php
/*
 本代码由 焕岱科技 创建
 技术支持 WX：15285007200
 严禁反编译、逆向等任何形式的侵权行为，违者将追究法律责任
*/

namespace app\common\model\bbfxshop;

use think\Model;
use think\Db;
use app\common\model\bbfxshop\Weixin;
use DateTime;
use DateTimeZone;

class Shipping
{
    // 上传发货信息
    public static function upload($id,$type=1){
        global $_W;
        $texts = $_W['base']['fenxiao']['texts'];
        try {
            if($type == 1){
                $order = Db::name("bbfx_order")->where(['id'=>$id,'is_pay'=>1])->find();
                if(empty($order)){
                    throw new \Exception("订单不存在");
                }
                if($order['refund_status'] == 0 || $order['refund_status'] == 1){
                    throw new \Exception("订单已申请售后");
                }
                
                if($order['paytype'] != 1){
                    throw new \Exception("不是微信支付");
                }
                if($order['platform'] != 'wxapp'){
                    throw new \Exception("不是小程序用户下单");
                }
                
                if($order['order_type'] == 2 && $order['delivery_method'] == 1 && $order['status'] != 2){
                    throw new \Exception("订单未发货");
                }
                
                $order_goods = Db::name("bbfx_order_goods")->where(['order_id'=>$order['id']])->select();
                
                if($order['order_type'] == 2){
                    if($order['delivery_method'] == 1){
                        $logistics_type = 1;
                    }
                    else{
                        $logistics_type = 4;
                    }
                }
                else{
                    $logistics_type = 3;
                }
                $shipping_list = [];
                $goods_name = "";
                foreach ($order_goods as $key => $val){
                    $goods = iunserializer($val['goods_info']);
                    $str = $goods['title']."x".$val['total'];
                    if(!empty($goods_name)){
                        if(mb_strlen($goods_name."，".$str, "utf8") < 120){
                            $goods_name .= "，".$str;
                        }
                    }
                    else{
                        $goods_name = $str;
                    }
                }
                
                $shipping_info = ['item_desc'=>$goods_name];
                if($logistics_type == 1){
                    $express = iunserializer($order['express']);
                    $express_id = $express[0]['express_id'];
                    
                    $express_company = Db::name("bbfx_express")->where(['id'=>$express_id])->value("coding");
                    if(empty($express_company)){
                        throw new \Exception("物流公司编码错误");
                    }
                    
                    $shipping_info['tracking_no'] = $express[0]['express_no'];
                    $shipping_info['express_company'] = $express_company;
                    $shipping_info['contact'] = ['receiver_contact'=>secret($order['delivery_mobile'],true,3,4)];
                    
                }
                
                
                $shipping_list[] = $shipping_info;
            }
            else if($type == 2){
                
                $order = Db::name("bbfx_recharge_order")->where(['id'=>$id,'is_pay'=>1])->find();
                if(empty($order)){
                    throw new \Exception("订单不存在");
                }
                
                if($order['type'] == 2){
                    $title = "积分充值";
                }
                else{
                    $title = "余额充值";
                }
                
                $logistics_type = 3;
                $shipping_list = [
                    ['item_desc'=>$title]
                ];
            }
            else if($type == 3){
                $order = Db::name("bbfx_member_card_order")->where(['id'=>$id,'status'=>1])->find();
                if(empty($order)){
                    throw new \Exception("订单不存在");
                }
                $logistics_type = 3;
                $shipping_list = [
                    ['item_desc'=>'购买会员卡']
                ];
            }
            else if($type == 4){
                $order = Db::name("bbfx_deposit_release_order")->where(['id'=>$id,'status'=>1])->find();
                if(empty($order)){
                    throw new \Exception("订单不存在");
                }
                $logistics_type = 3;
                $shipping_list = [
                    ['item_desc'=>$texts['deposit_release'].'充值']
                ];
            }
            else if($type == 5){
                $order = Db::name("bbfx_sconnection_upgrade_order")->where(['id'=>$id,'status'=>1])->find();
                if(empty($order)){
                    throw new \Exception("订单不存在");
                }
                $logistics_type = 3;
                $shipping_list = [
                    ['item_desc'=>$order['title']]
                ];
            }
            else if($type == 6){
                $order = Db::name("bbfx_scoreshop_order")->where(['id'=>$id,'status'=>['>',0]])->find();
                if(empty($order)){
                    throw new \Exception("订单不存在");
                }
                if($order['refund_status'] == 0 || $order['refund_status'] == 1){
                    throw new \Exception("订单已申请售后");
                }
                
                if($order['paytype'] != 1){
                    throw new \Exception("不是微信支付");
                }
                if($order['platform'] != 'wxapp'){
                    throw new \Exception("不是小程序用户下单");
                }
                if($order['price'] <= 0){
                    throw new \Exception("订单实付金额为0");
                }
                
                if($order['order_type'] == 2 && $order['delivery_method'] == 1 && $order['status'] != 2){
                    throw new \Exception("订单未发货");
                }
                
                $order_goods = Db::name("bbfx_scoreshop_order_goods")->where(['order_id'=>$order['id']])->select();
                
                if($order['order_type'] == 2){
                    if($order['delivery_method'] == 1){
                        $logistics_type = 1;
                    }
                    else{
                        $logistics_type = 4;
                    }
                }
                else{
                    $logistics_type = 3;
                }
                $shipping_list = [];
                $goods_name = "";
                foreach ($order_goods as $key => $val){
                    $goods = iunserializer($val['goods_info']);
                    $str = $goods['title']."x".$val['total'];
                    if(!empty($goods_name)){
                        if(mb_strlen($goods_name."，".$str, "utf8") < 120){
                            $goods_name .= "，".$str;
                        }
                    }
                    else{
                        $goods_name = $str;
                    }
                }
                
                $shipping_info = ['item_desc'=>$goods_name];
                if($logistics_type == 1){
                    $express = iunserializer($order['express']);
                    $express_id = $express[0]['express_id'];
                    
                    $express_company = Db::name("bbfx_express")->where(['id'=>$express_id])->value("coding");
                    if(empty($express_company)){
                        throw new \Exception("物流公司编码错误");
                    }
                    
                    $shipping_info['tracking_no'] = $express[0]['express_no'];
                    $shipping_info['express_company'] = $express_company;
                    $shipping_info['contact'] = ['receiver_contact'=>secret($order['delivery_mobile'],true,3,4)];
                    
                }
                
                
                $shipping_list[] = $shipping_info;
            }
            else if($type == 7){
                $order = Db::name("bbfx_yajin_record")->where(['id'=>$id,'status'=>['>',0]])->find();
                if(empty($order)){
                    throw new \Exception("订单不存在");
                }
                $logistics_type = 3;
                $shipping_list = [
                    ['item_desc'=>$order['title']]
                ];
            }
            else{
                throw new \Exception("未知订单类型");
            }
            
            $result = Weixin::getAccessToken();
            if($result['code'] != 1){
                return $result;
            }
            
            $access_token = $result['data'];
            // print_r($access_token);die;
            
            $order_no = $order['order_no'];
            if(empty($order_no)){
                throw new \Exception("订单号错误");
            }
            $pay_order = Db::name("bbfx_pay_order")->where(['order_no'=>$order_no,'order_type'=>$type,'paytype'=>1])->find();
            if(empty($pay_order)){
                throw new \Exception("未查询到微信支付记录");
            }
            if($pay_order['is_shipping'] == 1){
                throw new \Exception("已上传发货信息");
            }
            if($pay_order['platform'] != 'wxapp'){
                throw new \Exception("不是小程序平台下单");
            }
            $openid = $pay_order['openid'];
            if(empty($openid)){
                throw new \Exception("openid错误");
            }
            $transaction_id = $pay_order['transaction_id'];
            
            if(!empty($transaction_id)){
                $order_key = ['order_number_type'=>2,'transaction_id'=>$transaction_id];    
            }
            else{
                if(empty($pay_order['mchid'])){
                    throw new \Exception("下单商户号不存在");
                }
                $order_key = ['order_number_type'=>1,'mchid'=>$pay_order['mchid'],'out_trade_no'=>$order_no];    
            }
            
            // order_key 订单，需要上传物流信息的订单
            // logistics_type 物流模式，发货方式枚举值：1、实体物流配送采用快递公司进行实体物流配送形式 2、同城配送 3、虚拟商品，虚拟商品，例如话费充值，点卡等，无实体配送形式 4、用户自提
            // delivery_mode 发货模式，发货模式枚举值：1、UNIFIED_DELIVERY（统一发货）2、SPLIT_DELIVERY（分拆发货） 示例值: UNIFIED_DELIVERY
            
            // $date = new DateTime();
            // $date->setTimezone(new DateTimeZone('Asia/Shanghai'));
            // $upload_time = $date->format(DateTime::ATOM);
            $upload_time = date(DATE_RFC3339,time());
            
            $data = [
                'order_key'=>$order_key,
                'logistics_type'=>$logistics_type,
                'delivery_mode'=>'UNIFIED_DELIVERY',
                // 'is_all_delivered'=>true,
                'shipping_list'=>$shipping_list,
                'upload_time'=>$upload_time,
                'payer'=>['openid'=>$openid]
            ];
            
            // return $data;
            
            $result = ihttp_post("https://api.weixin.qq.com/wxa/sec/order/upload_shipping_info?access_token=".$access_token,json_encode($data,JSON_UNESCAPED_UNICODE));
            $result = json_decode($result['content'],true);
            file_put_contents("upload_shipping_info.txt",json_encode(['type'=>$type,'result'=>$result,'data'=>$data]));
            if($result['errcode'] === 0){
                
                Db::name("bbfx_pay_order")->where(['id'=>$pay_order['id']])->update(['is_shipping'=>1]);
                
                $result = __json(1,"操作成功");
            }
            else{
                throw new \Exception($result['errmsg']);
            }
        } 
        catch (\Exception $e) {
            file_put_contents("upload_shipping_info.txt",json_encode(['type'=>$type,'result'=>$e->getMessage(),'data'=>$data]));
            $result = __json(0,$e->getMessage());
        }
        
        return $result;
    }
    
    // 查询订单发货状
    public function getOrderShippingInfo($order_no){
        $result = Weixin::getAccessToken();
        if($result['code'] != 1){
            return $result;
        }
        
        $access_token = $result['data'];
        
        $data = [
            'merchant_trade_no'=>$order_no
        ];
        
        $result = ihttp_request("https://api.weixin.qq.com/wxa/sec/order/get_order?access_token=".$access_token,$data);
        $result = json_decode($result['content'],true);
        if($result['errcode'] === 0){
            
            return __json(1,"操作成功",$result);
        }
        
        return __json(0,$result['errmsg']);
    }
    
    // 获取运力ID列表
    public function getDeliveryList(){
        $result = Weixin::getAccessToken();
        if($result['code'] != 1){
            return $result;
        }
        $access_token = $result['data'];
        $data = '{}';
        $result = ihttp_post("https://api.weixin.qq.com/cgi-bin/express/delivery/open_msg/get_delivery_list?access_token=".$access_token,$data);
        $result = json_decode($result['content'],true);
        if($result['errcode'] === 0){
            return __json(1,"操作成功",$result);
        }
        
        return __json(0,$result['errmsg']);
    }
}